/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.ranged;

import dev.xkmc.mob_weapon_api.api.projectile.ProjectileWeaponUser;
import dev.xkmc.mob_weapon_api.api.simple.IHoldWeaponBehavior;
import dev.xkmc.mob_weapon_api.registry.WeaponRegistry;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemRangedAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemUser;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class GolemHoldRangedAttackGoal
extends GolemRangedAttackGoal {
    private int attackTime = -1;

    public GolemHoldRangedAttackGoal(HumanoidGolemEntity mob, GolemMeleeGoal melee, double speed) {
        super(mob, melee, speed, 0.0);
    }

    @Override
    public boolean mayActivate(HumanoidGolemEntity golem, ItemStack stack) {
        Optional weapon = WeaponRegistry.HOLD.get((LivingEntity)this.mob, stack);
        return weapon.isPresent() && ((IHoldWeaponBehavior)weapon.get()).isValid((ProjectileWeaponUser)new GolemUser(golem, null), stack);
    }

    @Override
    public void m_8041_() {
        this.attackTime = -1;
    }

    @Override
    public double radius(ItemStack stack) {
        Optional weapon = WeaponRegistry.HOLD.get((LivingEntity)this.mob, stack);
        return weapon.map(b -> b.range((LivingEntity)this.mob, stack)).orElse(0.0);
    }

    public void m_8037_() {
        this.doMelee();
        this.strafing();
        ItemStack stack = this.mob.m_21120_(this.mob.getWeaponHand());
        Optional weapon = WeaponRegistry.HOLD.get((LivingEntity)this.mob, stack);
        if (weapon.isEmpty()) {
            return;
        }
        LivingEntity target = this.mob.m_5448_();
        GolemUser user = new GolemUser(this.mob, target);
        if (this.mob.m_6117_() && target != null) {
            if (this.seeTime < -60) {
                this.mob.m_5810_();
            } else if (this.seeTime > 0) {
                int i = this.mob.m_21252_();
                if (i >= ((IHoldWeaponBehavior)weapon.get()).holdTime((LivingEntity)this.mob, stack)) {
                    this.attackTime = ((IHoldWeaponBehavior)weapon.get()).trigger((ProjectileWeaponUser)user, stack, target, i);
                    this.mob.m_5810_();
                } else {
                    ((IHoldWeaponBehavior)weapon.get()).tickUsing((ProjectileWeaponUser)user, stack, i);
                }
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60 && target != null && (double)this.mob.m_20270_((Entity)target) < ((IHoldWeaponBehavior)weapon.get()).range((LivingEntity)this.mob, stack)) {
            this.mob.m_6672_(this.mob.getWeaponHand());
        }
    }

    @Override
    public void performRangedAttack(HumanoidGolemEntity golem, LivingEntity target, float power, ItemStack stack, InteractionHand hand) {
    }
}

